﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.User;
using System.Diagnostics;

namespace ClipClop.View
{
	public partial class ContextMenuParentForm : Form
	{
		public ContextMenuParentForm()
		{
			InitializeComponent();
		}

        public ContextMenuParentForm(DynamicContextMenuStrip menu)
        {
            InitializeComponent();

            //枠を消す
            this.FormBorderStyle = FormBorderStyle.None;

            this.TopMost = true;
            this.ShowInTaskbar = true;

            this.Size = Size.Empty;
            
            this.ContextMenuStrip = menu;
            this.ContextMenuStrip.TabStop = true;

            this.ContextMenuStrip.Closed += this.OnContextMenuClosed;
        }


		private void ContextMenuParentForm_Shown(object sender, EventArgs e)
		{
            Debug.WriteLine("=>Shown");
			//インスタンス生成後一回だけ
        }

        private void ContextMenuParentForm_Activated(object sender, EventArgs e)
        {
            //表示がアクティブになる度に呼ばれる
            Debug.WriteLine("=>Actived");
            this.ContextMenuStrip.Show(this.Location);

            // SelectMenuItem();
        }

        void SelectMenuItem()
        {
            foreach (ToolStripItem item in ContextMenuStrip.Items)
            {
                if (item.Enabled == true)
                {
                    if (item.CanSelect)
                    {
                        item.Select();
                    }
                    break;
                }
            }
        }

		/// <summary>
		/// ContextMenuが閉じたら呼ばれるようにしているイベント
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		public void OnContextMenuClosed(object sender, ToolStripDropDownClosedEventArgs e)
		{
			this.Close();
		}

		private void ContextMenuParentForm_Deactivate(object sender, EventArgs e)
		{
            Debug.WriteLine("=>dective");

			//Debug.WriteLine(this.ContextMenuStrip.Visible) ;

            if (this.ContextMenuStrip.Visible == false)
			{
				//ContextMenuのアイテムが選択された
			}
			else
			{
				//フォーカスが外れた
				this.Close();
			}
		}

        //private void ContextMenuParentForm_Load(object sender, EventArgs e)
        //{
        //    Debug.WriteLine("=>Load");
        //}

        //private void ContextMenuParentForm_MouseCaptureChanged(object sender, EventArgs e)
        //{
        //    Debug.WriteLine("=>MouseCaptureChanged");
        //}

        private void ContextMenuParentForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Debug.WriteLine("=>FormClosing");
            this.ContextMenuStrip.Closed -= this.OnContextMenuClosed;
        }

        //private void ContextMenuParentForm_FormClosed(object sender, FormClosedEventArgs e)
        //{
        //    Debug.WriteLine("=>FormClosed");
        //}

        //private void ContextMenuParentForm_Leave(object sender, EventArgs e)
        //{
        //    Debug.WriteLine("=>Leave");
        //}

        //private void ContextMenuParentForm_Enter(object sender, EventArgs e)
        //{
        //    Debug.WriteLine("=>Enter");
        //}

		
	}
}
